/****** Object:  StoredProcedure [dbo].[P_RC_VD_CONV_GERAR_VENDAS_CONVENIO]    Script Date: 06/16/2012 13:50:42 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_RC_VD_CONV_GERAR_VENDAS_CONVENIO]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_RC_VD_CONV_GERAR_VENDAS_CONVENIO]
GO
--exec P_RC_VD_CONV_GERAR_VENDAS_CONVENIO 1,522,'2016-07-22'
CREATE PROCEDURE P_RC_VD_CONV_GERAR_VENDAS_CONVENIO @CD_EMP INT, @CD_FILIAL INT, @DT_PROC DATETIME
WITH ENCRYPTION
AS
DECLARE @CD_VD INT
DECLARE @VLR_CONV MONEY
DECLARE @CD_CLI INT
DECLARE @CD_CONV INT
DECLARE @CD_USU INT
DECLARE @DT_VD DATETIME
DECLARE @HR_VD DATETIME
DECLARE @CD_CX INT
DECLARE @NR_ECF INT
DECLARE @CD_CTR INT	
SET NOCOUNT ON

PRINT 'VERIFICANDO CUPOM PARA CRIACAO ' + CONVERT(VARCHAR, GETDATE(),108) 
--Criando venda de convenio sem vinculo com o cupom fiscal
DECLARE CPROCVENDACONVENIOCRIACAO CURSOR FAST_FORWARD FOR 
	SELECT
		P.CD_EMP,
		P.CD_FILIAL,
		P.CD_VD,
		P.VLR_CONV,
		P.CD_CLI,
		P.CD_CONV,
		P.CD_USU,
		P.DT_VD,
		P.HR_VD,
		P.CD_CX,
		P.NR_ECF
	FROM
		PDV_VD P LEFT OUTER JOIN PDV_VD_RC_VD_CONV C ON
		P.CD_EMP = C.CD_EMP AND
		P.CD_FILIAL = C.CD_FILIAL AND
		P.CD_VD = C.CD_VD 
		LEFT OUTER JOIN RC_VD_CONV CONV ON
		P.CD_EMP = CONV.CD_EMP AND
		P.CD_FILIAL = CONV.CD_FILIAL AND
		P.CD_CX = CONV.CD_CX AND
		P.NR_ECF = CONV.NR_ECF AND
		P.DT_VD = CONV.DT_VD
	WHERE
		P.CD_EMP =@CD_EMP
		AND P.CD_FILIAL = @CD_FILIAL
		AND P.VLR_CONV > 0
		AND P.DT_VD >= @DT_PROC
		AND P.ST_VD=0
		AND C.CD_VD IS NULL
		AND CONV.CD_CTR IS NULL


OPEN CPROCVENDACONVENIOCRIACAO
FETCH NEXT FROM CPROCVENDACONVENIOCRIACAO INTO @CD_EMP,@CD_FILIAL,@CD_VD,@VLR_CONV,@CD_CLI,@CD_CONV,@CD_USU,@DT_VD,@HR_VD,@CD_CX,@NR_ECF
	WHILE @@FETCH_STATUS=0
	  BEGIN
		PRINT 'FILIAL CRIACAO' + CONVERT(VARCHAR, @CD_FILIAL) + ' ' + CONVERT(VARCHAR, @DT_VD,112) 
		--Criando a venda de convenio
		SET @CD_CTR = (SELECT ISNULL(MAX(CD_CTR),0)+1 FROM RC_VD_CONV WHERE CD_EMP=@CD_EMP)
		INSERT INTO RC_VD_CONV
		  (CD_EMP,
		  CD_CTR,
		  CD_FILIAL,
		  CD_CX,
		  NR_ECF,
		  CD_CLI,
		  DT_VD,
		  DT_FECHA,
		  VLR_CONV,
		  ST_FECHVD_CONV,
		  CD_USU,
		  DT_CAD,
		  DT_ATUAL,
		  TP_LANC,
		  NR_AUTORIZACAO,
		  PARC,
		  TP_CANCEL,
		  CD_CONV,
		  HR_VD,
		  DT_GLOSA,
		  FLAG_CONV_AFASTADO,
		  DT_CAD_AUDIT,
		  ORIG_CONS,
		  QTD_DIAS_PRORROG)
		  SELECT
			@CD_EMP,
			@CD_CTR,
			@CD_FILIAL,
			@CD_CX,
			@NR_ECF,
			@CD_CLI,
			@DT_VD AS DT_VD,
			@DT_VD AS DT_FECHA,
			@VLR_CONV AS VLR_CONV,
			0 AS ST_FECHVD_CONV,
			@CD_USU,
			@DT_VD AS DT_CAD,
			NULL AS DT_ATUAL,
			0 AS TP_LANC,
			'' AS NR_AUTORIZACAO,
			1 AS PARC,
			0 AS TP_CANCEL,
			@CD_CONV AS CD_CONV,
			@HR_VD AS HR_VD,
			NULL AS DT_GLOSA,
			0 AS FLAG_CONV_AFASTADO,
			NULL AS DT_CAD_AUDIT,
			0 AS ORIG_CONS,
			0 AS QTD_DIAS_PRORROG

		  --Vinculo da vendas com a do convenio	
		  INSERT INTO PDV_VD_RC_VD_CONV
			(CD_EMP,
			CD_FILIAL,
			CD_VD,
			CD_CTR)
		  SELECT
			@CD_EMP,
			@CD_FILIAL,
			@CD_VD,
			@CD_CTR

		FETCH NEXT FROM CPROCVENDACONVENIOCRIACAO INTO @CD_EMP,@CD_FILIAL,@CD_VD,@VLR_CONV,@CD_CLI,@CD_CONV,@CD_USU,@DT_VD,@HR_VD,@CD_CX,@NR_ECF
	  END
--Fim
CLOSE CPROCVENDACONVENIOCRIACAO;
DEALLOCATE CPROCVENDACONVENIOCRIACAO;

SET @CD_VD = 0
SET @CD_CTR =0

PRINT 'VERIFICANDO CUPOM A VINCULAR ' + CONVERT(VARCHAR, GETDATE(),108) 
--Criando venda de convenio sem vinculo com o cupom fiscal
DECLARE CPROCVENDACONVENIOVINCULACAO CURSOR FAST_FORWARD FOR 
	SELECT
		P.CD_EMP,
		P.CD_FILIAL,
		P.CD_VD,
		CONV.CD_CTR
	FROM
		PDV_VD P LEFT OUTER JOIN PDV_VD_RC_VD_CONV C ON
		P.CD_EMP = C.CD_EMP AND
		P.CD_FILIAL = C.CD_FILIAL AND
		P.CD_VD = C.CD_VD 
		INNER JOIN RC_VD_CONV CONV ON
		P.CD_EMP = CONV.CD_EMP AND
		P.CD_FILIAL = CONV.CD_FILIAL AND
		P.CD_CX = CONV.CD_CX AND
		P.NR_ECF = CONV.NR_ECF AND
		P.DT_VD = CONV.DT_VD
	WHERE
		P.CD_EMP =@CD_EMP
		AND P.CD_FILIAL = @CD_FILIAL
		AND P.VLR_CONV > 0
		AND P.DT_VD >= @DT_PROC
		AND P.ST_VD=0
		AND C.CD_VD IS NULL


OPEN CPROCVENDACONVENIOVINCULACAO
FETCH NEXT FROM CPROCVENDACONVENIOVINCULACAO INTO @CD_EMP,@CD_FILIAL,@CD_VD,@CD_CTR
	WHILE @@FETCH_STATUS=0
	  BEGIN
		PRINT 'FILIAL VINCULACAO' + CONVERT(VARCHAR, @CD_FILIAL) + ' ' + CONVERT(VARCHAR, @DT_VD,112) 
		  --Vinculo da vendas com a do convenio	
		  INSERT INTO PDV_VD_RC_VD_CONV
			(CD_EMP,
			CD_FILIAL,
			CD_VD,
			CD_CTR)
		  SELECT
			@CD_EMP,
			@CD_FILIAL,
			@CD_VD,
			@CD_CTR

		FETCH NEXT FROM CPROCVENDACONVENIOVINCULACAO INTO @CD_EMP,@CD_FILIAL,@CD_VD,@CD_CTR
	  END
--FIM


CLOSE CPROCVENDACONVENIOVINCULACAO;
DEALLOCATE CPROCVENDACONVENIOVINCULACAO;



